/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class CConfigureConfigPacket<T>
extends SimplePacketBase {
    private String modID;
    private String path;
    private String value;

    public CConfigureConfigPacket(String modID, String path, T value) {
        this.modID = Objects.requireNonNull(modID);
        this.path = path;
        this.value = this.serialize(value);
    }

    public CConfigureConfigPacket(class_2540 buffer) {
        this.modID = buffer.method_10800(Short.MAX_VALUE);
        this.path = buffer.method_10800(Short.MAX_VALUE);
        this.value = buffer.method_10800(Short.MAX_VALUE);
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10814(this.modID);
        buffer.method_10814(this.path);
        buffer.method_10814(this.value);
    }

    @Override
    public void handle(Supplier<SimplePacketBase.Context> context) {
        context.get().enqueueWork(() -> {
            try {
                ForgeConfigSpec.ConfigValue configValue;
                Object v;
                class_3222 sender = ((SimplePacketBase.Context)context.get()).getSender();
                if (sender == null || !sender.method_5687(2)) {
                    return;
                }
                ForgeConfigSpec spec = ConfigHelper.findForgeConfigSpecFor(ModConfig.Type.SERVER, this.modID);
                if (spec == null) {
                    return;
                }
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(this.path);
                if (!valueSpec.test(v = CConfigureConfigPacket.deserialize((configValue = (ForgeConfigSpec.ConfigValue)spec.getValues().get(this.path)).get(), this.value))) {
                    return;
                }
                configValue.set(v);
            }
            catch (Exception e) {
                Create.LOGGER.warn("Unable to handle ConfigureConfig Packet. ", (Throwable)e);
            }
        });
        context.get().setPacketHandled(true);
    }

    public String serialize(T value) {
        if (value instanceof Boolean) {
            return Boolean.toString((Boolean)value);
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Float) {
            return Float.toString(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Double.toString((Double)value);
        }
        throw new IllegalArgumentException("unknown type " + value + ": " + value.getClass().getSimpleName());
    }

    public static Object deserialize(Object type, String sValue) {
        if (type instanceof Boolean) {
            return Boolean.parseBoolean(sValue);
        }
        if (type instanceof Enum) {
            return Enum.valueOf(((Enum)type).getClass(), sValue);
        }
        if (type instanceof Integer) {
            return Integer.parseInt(sValue);
        }
        if (type instanceof Float) {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        if (type instanceof Double) {
            return Double.parseDouble(sValue);
        }
        throw new IllegalArgumentException("unknown type " + type + ": " + type.getClass().getSimpleName());
    }
}

